/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.impl.humantask;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.drools.runtime.process.WorkItem;
import org.jbpm.process.instance.impl.humantask.HumanTaskHandler;

public class HumanTaskDialog
extends JDialog {
    private static final long serialVersionUID = 510L;
    private HumanTaskHandler handler;
    private WorkItem workItem;
    private JTextField resultNameField;
    private JTextField resultValueField;
    private List<Result> results = new ArrayList<Result>();
    private JList resultList;
    private JButton removeResultButton;
    private JButton completeButton;
    private JButton abortButton;

    public HumanTaskDialog(HumanTaskHandler handler, WorkItem workItem) {
        super(handler, "Execute Human Task", true);
        this.handler = handler;
        this.workItem = workItem;
        this.setSize(new Dimension(400, 400));
        this.initializeComponent();
    }

    private void initializeComponent() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.getRootPane().setLayout(new BorderLayout());
        this.getRootPane().add((Component)panel, "Center");
        JLabel nameLabel = new JLabel("Name");
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)nameLabel, c);
        String taskName = (String)this.workItem.getParameter("TaskName");
        JTextField nameField = new JTextField(taskName == null ? "" : taskName);
        nameField.setEditable(false);
        c = new GridBagConstraints();
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)nameField, c);
        JLabel priorityLabel = new JLabel("Priority");
        c = new GridBagConstraints();
        c.gridy = 1;
        c.anchor = 17;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)priorityLabel, c);
        String priority = (String)this.workItem.getParameter("Priority");
        JTextField priorityField = new JTextField(priority == null ? "" : priority);
        priorityField.setEditable(false);
        c = new GridBagConstraints();
        c.gridy = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)priorityField, c);
        JLabel commentLabel = new JLabel("Comment");
        c = new GridBagConstraints();
        c.gridy = 2;
        c.anchor = 17;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)commentLabel, c);
        String comment = (String)this.workItem.getParameter("Comment");
        JTextArea params = new JTextArea(comment == null ? "" : comment);
        params.setEditable(false);
        c = new GridBagConstraints();
        c.gridy = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)params, c);
        int additionalParameters = 0;
        for (Map.Entry<String, Object> entry : this.workItem.getParameters().entrySet()) {
            String name = entry.getKey();
            if ("TaskName".equals(name) || "Priority".equals(name) || "Comment".equals(name) || "ActorId".equals(name)) continue;
            JLabel label = new JLabel(name);
            c = new GridBagConstraints();
            c.gridy = 2 + ++additionalParameters;
            c.anchor = 17;
            c.insets = new Insets(5, 5, 5, 5);
            panel.add((Component)label, c);
            JTextField field = new JTextField(this.workItem.getParameter(name).toString());
            field.setEditable(false);
            c = new GridBagConstraints();
            c.gridy = 2 + additionalParameters;
            c.weightx = 1.0;
            c.fill = 2;
            c.insets = new Insets(5, 5, 5, 5);
            panel.add((Component)field, c);
        }
        JPanel resultPanel = new JPanel();
        resultPanel.setLayout(new GridBagLayout());
        resultPanel.setBorder(new TitledBorder("Results"));
        JLabel resultNameLabel = new JLabel("Name");
        c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        resultPanel.add((Component)resultNameLabel, c);
        this.resultNameField = new JTextField();
        c = new GridBagConstraints();
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        resultPanel.add((Component)this.resultNameField, c);
        JLabel resultValueLabel = new JLabel("Value");
        c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        resultPanel.add((Component)resultValueLabel, c);
        this.resultValueField = new JTextField();
        c = new GridBagConstraints();
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        resultPanel.add((Component)this.resultValueField, c);
        JButton addResultButton = new JButton("Add");
        addResultButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HumanTaskDialog.this.addResult();
            }
        });
        c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        resultPanel.add((Component)addResultButton, c);
        this.resultList = new JList();
        this.resultList.setSelectionMode(0);
        this.resultList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                HumanTaskDialog.this.removeResultButton.setEnabled(HumanTaskDialog.this.resultList.getSelectedIndex() != -1);
            }
        });
        c = new GridBagConstraints();
        c.gridy = 1;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.resultList);
        resultPanel.add((Component)scrollPane, c);
        this.removeResultButton = new JButton("Remove");
        this.removeResultButton.setEnabled(false);
        this.removeResultButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HumanTaskDialog.this.removeResult();
            }
        });
        c = new GridBagConstraints();
        c.gridy = 1;
        c.anchor = 11;
        c.insets = new Insets(5, 5, 5, 5);
        resultPanel.add((Component)this.removeResultButton, c);
        c = new GridBagConstraints();
        c.gridy = 3 + additionalParameters;
        c.gridwidth = 2;
        c.weighty = 1.0;
        c.fill = 1;
        panel.add((Component)resultPanel, c);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new GridBagLayout());
        this.completeButton = new JButton("Complete");
        this.completeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                HumanTaskDialog.this.complete();
            }
        });
        c = new GridBagConstraints();
        c.weightx = 1.0;
        c.anchor = 13;
        c.insets = new Insets(5, 5, 5, 5);
        bottomPanel.add((Component)this.completeButton, c);
        this.abortButton = new JButton("Abort");
        this.abortButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                HumanTaskDialog.this.abort();
            }
        });
        c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        bottomPanel.add((Component)this.abortButton, c);
        c = new GridBagConstraints();
        c.gridy = 4 + additionalParameters;
        c.gridwidth = 2;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)bottomPanel, c);
    }

    private void addResult() {
        String name = this.resultNameField.getText();
        String value = this.resultValueField.getText();
        if ("".equals(name) || "".equals(value)) {
            JOptionPane.showMessageDialog(this, "Name or value of result may not be null!", "Error", 0);
            return;
        }
        Result result = new Result(name, value);
        if (this.results.contains(result)) {
            JOptionPane.showMessageDialog(this, "Cannot add result more than once!", "Error", 0);
            return;
        }
        this.results.add(result);
        this.reloadResultList();
        this.resultNameField.setText("");
        this.resultValueField.setText("");
    }

    private void reloadResultList() {
        this.resultList.setListData(this.results.toArray());
    }

    private void removeResult() {
        int index = this.resultList.getSelectedIndex();
        if (index != -1) {
            this.results.remove(index);
            this.reloadResultList();
        }
    }

    private void complete() {
        HashMap<String, Object> resultMap = null;
        if (this.results.size() > 0) {
            resultMap = new HashMap<String, Object>();
            for (Result result : this.results) {
                resultMap.put(result.getName(), result.getValue());
            }
        }
        this.handler.complete(this.workItem, resultMap);
        this.dispose();
    }

    private void abort() {
        this.handler.abort(this.workItem);
        this.dispose();
    }

    public static class Result {
        private String name;
        private Object value;

        public Result(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return this.name + " = " + this.value;
        }

        public boolean equals(Object o) {
            if (o instanceof Result) {
                return ((Result)o).getName().equals(this.name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

